<?php
/**
 * Template Name: Registro Candidato Step Two
 * Template used for pages.
 *
 * @package Avada
 * @subpackage Templates
 */

// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'Direct script access denied.' );
}
?>

<?php get_header(); 
$url = get_home_url();
?>

<div id="content" <?php Avada()->layout->add_style( 'content_style' ); ?>>
	<?php while ( have_posts() ) : the_post(); ?>
		<div id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
			<?php echo wp_kses_post( fusion_render_rich_snippets_for_pages() ); ?>
			<?php if ( ! post_password_required( $post->ID ) ) : ?>
				<?php if ( Avada()->settings->get( 'featured_images_pages' ) ) : ?>
					<?php if ( 0 < avada_number_of_featured_images() || get_post_meta( $post->ID, 'pyre_video', true ) ) : ?>
						<div class="fusion-flexslider flexslider post-slideshow">
							<ul class="slides">
								<?php if ( get_post_meta( $post->ID, 'pyre_video', true ) ) : ?>
									<li>
										<div class="full-video">
											<?php echo wp_kses_post( get_post_meta( $post->ID, 'pyre_video', true ) ); ?>
										</div>
									</li>
								<?php endif; ?>
								<?php if ( has_post_thumbnail() && 'yes' != get_post_meta( $post->ID, 'pyre_show_first_featured_image', true ) ) : ?>
									<?php $attachment_image = wp_get_attachment_image_src( get_post_thumbnail_id(), 'full' ); ?>
									<?php $full_image       = wp_get_attachment_image_src( get_post_thumbnail_id(), 'full' ); ?>
									<?php $attachment_data  = wp_get_attachment_metadata( get_post_thumbnail_id() ); ?>
									<li>
										<a href="<?php echo esc_url_raw( $full_image[0] ); ?>" data-rel="iLightbox[gallery<?php the_ID(); ?>]" title="<?php echo esc_attr( get_post_field( 'post_excerpt', get_post_thumbnail_id() ) ); ?>" data-title="<?php echo esc_attr( get_post_field( 'post_title', get_post_thumbnail_id() ) ); ?>" data-caption="<?php echo esc_attr( get_post_field( 'post_excerpt', get_post_thumbnail_id() ) ); ?>">
											<img src="<?php echo esc_url_raw( $attachment_image[0] ); ?>" alt="<?php echo esc_attr( get_post_meta( get_post_thumbnail_id(), '_wp_attachment_image_alt', true ) ); ?>" role="presentation" />
										</a>
									</li>
								<?php endif; ?>
								<?php $i = 2; ?>
								<?php while ( $i <= Avada()->settings->get( 'posts_slideshow_number' ) ) : ?>
									<?php $attachment_new_id = kd_mfi_get_featured_image_id( 'featured-image-' . $i, 'page' ); ?>
									<?php if ( $attachment_new_id ) : ?>
										<?php $attachment_image = wp_get_attachment_image_src( $attachment_new_id, 'full' ); ?>
										<?php $full_image       = wp_get_attachment_image_src( $attachment_new_id, 'full' ); ?>
										<?php $attachment_data  = wp_get_attachment_metadata( $attachment_new_id ); ?>
										<li>
											<a href="<?php echo esc_url_raw( $full_image[0] ); ?>" data-rel="iLightbox[gallery<?php the_ID(); ?>]" title="<?php echo esc_attr( get_post_field( 'post_excerpt', $attachment_new_id ) ); ?>" data-title="<?php echo esc_attr( get_post_field( 'post_title', $attachment_new_id ) ); ?>" data-caption="<?php echo esc_attr( get_post_field( 'post_excerpt', $attachment_new_id ) ); ?>">
												<img src="<?php echo esc_url_raw( $attachment_image[0] ); ?>" alt="<?php echo esc_attr( get_post_meta( $attachment_new_id, '_wp_attachment_image_alt', true ) ); ?>" role="presentation" />
											</a>
										</li>
									<?php endif; ?>
									<?php $i++; ?>
								<?php endwhile; ?>
							</ul>
						</div>
					<?php endif; ?>
				<?php endif; ?>
			<?php endif; // Password check. ?>

			<div class="post-content">
				<?php the_content(); ?>
				<?php fusion_link_pages(); ?>
 
				<?php

				$signup_form_left = '
<form id="signup" class="register mis-formularios" action="" method="post" name="signup" enctype="multipart/form-data">
	<!-- seccion de foto de perfil -->
	<div class="fusion-layout-column fusion_builder_column fusion_builder_column_1_1  fusion-one-full fusion-column-first fusion-column-last 1_1" style="margin-top:0px;margin-bottom:20px;">
		<div class="fusion-column-wrapper" style="background-position:left top;background-repeat:no-repeat;-webkit-background-size:cover;-moz-background-size:cover;-o-background-size:cover;background-size:cover;" data-bg-url="">
			<div class="fusion-title title fusion-sep-none fusion-title-center fusion-title-size-one fusion-border-below-title" style="padding-top:25px;padding-bottom:30px; background:#f9f9f9;">
				<h3>Foto de perfil</h3>
				<div id="imgPerfil">
					<label for="fotoPerfil">Subir imagen:</label> <input type="file" name="file" id="fotoPerfil" onchange="if(!this.value.length)return false; subirFoto();">
				</div>
				<input type="hidden" id="x" name="x" />
			    <input type="hidden" id="y" name="y" />
			    <input type="hidden" id="w" name="w" />
			    <input type="hidden" id="h" name="h" />
			</div>
			<div class="fusion-clearfix"></div>

		</div>
	</div>
	<div class="fusion-fullwidth fullwidth-box fusion-blend-mode nonhundred-percent-fullwidth" style="background-color: rgba(255,255,255,0);background-position: center center;background-repeat: no-repeat;padding-top:0px;padding-right:0px;padding-bottom:0px;padding-left:0px;">
		<div class="fusion-builder-row fusion-row "><div class="fusion-layout-column fusion_builder_column fusion_builder_column_1_2  fusion-one-half fusion-column-first fusion-column-no-min-height 1_2" style="margin-top:0px;margin-bottom:0px;width:50%;width:calc(50% - ( ( 2% ) * 0.5 ) );margin-right: 2%;">
			<div class="fusion-column-wrapper" style="padding: 15px 0px 15px 0px;background-position:left top;background-repeat:no-repeat;-webkit-background-size:cover;-moz-background-size:cover;-o-background-size:cover;background-size:cover;" data-bg-url="">
						<p>
						<label for="dtnacimiento">Fecha de nacimiento*</label>
						<input id="dtnacimiento" type="text" name="dtnacimiento" data-validation="required" value="">
						</p>
						<p>

						<label for="tel">Teléfono*</label>
						<input id="tel" type="text" name="tel" data-validation="required length" data-validation-length="min10" value="" />
						</p>
						<p>
						<label for="cel">Celular </label>
						<input id="cel" type="text" name="cel" data-validation="" value="" />
						</p>
						
						<p>
						<label for="genero">Genero*</label>
						<select name="genero" data-validation="required">
							<option>Selecciona una opción</option>
							<option value="Femenino">Femenino</option>
							<option value="Masculino">Masculino</option>
						</select>
						</p>
						<p>
						<label for="calle">Calle: </label>
						<input id="calle" type="text" name="cp" data-validation="required" value="">
						</p>
						
						<div class="fusion-clearfix"></div>
					</div>
				</div>
				<div class="fusion-layout-column fusion_builder_column fusion_builder_column_1_2  fusion-one-half fusion-column-last fusion-column-no-min-height 1_2" style="margin-top:0px;margin-bottom:0px;width:50%;width:calc(50% - ( ( 2% ) * 0.5 ) );">
					<div class="fusion-column-wrapper" style="padding: 15px 0px 15px 0px;background-position:left top;background-repeat:no-repeat;-webkit-background-size:cover;-moz-background-size:cover;-o-background-size:cover;background-size:cover;" data-bg-url="">
						<p>
						<label for="num">Número: </label>
						<input id="interior" type="text" class="input-middle" name="interior" data-validation="required" value="" placeholder="Interior">
						<input id="exterior" type="text" class="input-middle-last" name="exterior" data-validation="" value="" placeholder="Exterior">
						</p>
						<p>
						<label for="cp">CP*: </label>
						<input id="cp" type="number" name="cp" data-validation="required length" data-validation-length="min5" value="">
						</p>
						<p>
						<label for="colonia">Colonia*: </label>
						<select name="colonia" id="colonia" data-validation="required">
							<option>Selecciona una opción</option>
						</select>
						</p>
						<p>
						<label for="estado">Estado*: </label>
						<input id="estado" type="text" name="estado" data-validation="required" value="" />
						</p>
						<p>
						<label for="delegacion">Municipio o Delegación*: </label>
						<input id="delegacion" type="text" name="delegacion" data-validation="required" value="">
						</p>
						<div id="mensaje"></div>
						<div class="fusion-clearfix"></div>
					</div>
				</div>
				
				
		</div>
	</div>

	<!-- segunda Seccion de formulario -->
	<div class="fusion-layout-column fusion_builder_column fusion_builder_column_1_1  fusion-one-full fusion-column-first fusion-column-last 1_1" style="margin-top:0px;margin-bottom:20px;">
		<div class="fusion-column-wrapper" style="background-position:left top;background-repeat:no-repeat;-webkit-background-size:cover;-moz-background-size:cover;-o-background-size:cover;background-size:cover;" data-bg-url="">
			<div class="fusion-title title fusion-sep-none fusion-title-center fusion-title-size-one fusion-border-below-title" style="padding-top:25px;padding-bottom:30px; background:#f9f9f9;">
				<h1 class="title-heading-center" data-fontsize="34" data-lineheight="47">
				Datos profesionales
				</h1>
			</div>
			<div class="fusion-clearfix"></div>

		</div>
	</div>

	<div class="fusion-fullwidth fullwidth-box fusion-blend-mode nonhundred-percent-fullwidth" style="background-color: rgba(255,255,255,0);background-position: center center;background-repeat: no-repeat;padding-top:0px;padding-right:0px;padding-bottom:0px;padding-left:0px;"><div class="fusion-builder-row fusion-row "><div class="fusion-layout-column fusion_builder_column fusion_builder_column_1_2  fusion-one-half fusion-column-first fusion-column-no-min-height 1_2" style="margin-top:0px;margin-bottom:0px;width:50%;width:calc(50% - ( ( 2% ) * 0.5 ) );margin-right: 2%;">
			<div class="fusion-column-wrapper" style="padding: 15px 0px 15px 0px;background-position:left top;background-repeat:no-repeat;-webkit-background-size:cover;-moz-background-size:cover;-o-background-size:cover;background-size:cover;" data-bg-url="">
						<p>
						<label for="titulo-cv">Titulo breve de tu curriculum *</label>
						<input id="titulo-cv" type="text" name="titulo-cv" data-validation="required" value="" placeholder="Ej: Analista de Crédito y Riesgo">
						</p>
						<p>

						<label for="descripcion">Descripción de tu perfil profesional *</label>
						<textarea name="descripcion" id="descripcion" data-validation="required" placeholder="Ej: Amplia experiencia en la área financiera analista de Crédito (énfasis en el manejo, identificación, clasificación, análisis y evaluación de operaciones de crédito). Análisis y aplicación de políticas financieras para la toma de decisiones en productos financieros y riesgo crediticio. Análisis de peticiones, quejas y reclamos."></textarea>
						</p>
						
						
						<div class="fusion-clearfix"></div>
					</div>
				</div>
				<div class="fusion-layout-column fusion_builder_column fusion_builder_column_1_2  fusion-one-half fusion-column-last fusion-column-no-min-height 1_2" style="margin-top:0px;margin-bottom:0px;width:50%;width:calc(50% - ( ( 2% ) * 0.5 ) );">
					<div class="fusion-column-wrapper" style="padding: 15px 0px 15px 0px;background-position:left top;background-repeat:no-repeat;-webkit-background-size:cover;-moz-background-size:cover;-o-background-size:cover;background-size:cover;" data-bg-url="">
						<p>
						<label for="salario">Salario deseado * </label>
						<input id="salario" type="text" name="salario" data-validation="required" value="" placeholder="Interior">
						</p>
						<p>
						<label for="viajar">Disponibilidad para viajar *: </label>
        				<span class="clear"></span>
            			
                			<input data-validation="required" id="viajar" name="viajar" type="radio" value="Si">
                			<span class="label-radio">Sí</span>
            			
                			<input data-validation="required" id="viajar" name="viajar" type="radio" value="No">
                			<span class="label-radio">No</span>
						</p>

						<label for="residencia">Disponibilidad para cambio de residencia *: </label>
        				<span class="clear"></span>
            			
                			<input data-validation="required" id="residencia" name="residencia" type="radio" value="Si">
                			<span class="label-radio">Sí</span>
            			
                			<input data-validation="required" id="residencia" name="residencia" type="radio" value="No">
                			<span class="label-radio">No</span>
						</p>
						
						
						<div class="fusion-clearfix"></div>
					</div>
				</div>
				<div class="fusion-layout-column fusion_builder_column fusion_builder_column_4_5  fusion-four-fifth fusion-column-first fusion-column-no-min-height 4_5" style="margin-top:0px;margin-bottom:0px;width:80%;width:calc(80% - ( ( 2% ) * 0.8 ) );margin-right: 2%;">
					<div class="fusion-column-wrapper" style="padding: 15px 0px 15px 0px;background-position:left top;background-repeat:no-repeat;-webkit-background-size:cover;-moz-background-size:cover;-o-background-size:cover;background-size:cover;" data-bg-url="">

					<div id="mensaje"></div>
					<div class="fusion-clearfix"></div>

					</div>
				</div>
				<div class="fusion-layout-column fusion_builder_column fusion_builder_column_1_5  fusion-one-fifth fusion-column-last fusion-column-no-min-height 1_5" style="margin-top:0px;margin-bottom:0px;width:20%;width:calc(20% - ( ( 2% ) * 0.2 ) );">
					
					<div id="escapingBallG-reg">
						<div id="escapingBall_1" class="escapingBallG"></div>
					</div>
					<div class="fusion-column-wrapper" style="padding: 3px 0px 0px 0px;background-position:left top;background-repeat:no-repeat;-webkit-background-size:cover;-moz-background-size:cover;-o-background-size:cover;background-size:cover;" data-bg-url="">
						<div class="fusion-button-wrapper fusion-aligncenter">
							<style type="text/css" scoped="scoped">.fusion-button.button-1 .fusion-button-text, .fusion-button.button-1 i {color:#ffffff;}.fusion-button.button-1 {border-width:0px;border-color:#ffffff;}.fusion-button.button-1 .fusion-button-icon-divider{border-color:#ffffff;}.fusion-button.button-1.button-3d{-webkit-box-shadow: inset 0px 1px 0px #fff,0px 4px 0px #105378,1px 6px 6px 3px rgba(0,0,0,0.3);-moz-box-shadow: inset 0px 1px 0px #fff,0px 4px 0px #105378,1px 6px 6px 3px rgba(0,0,0,0.3);box-shadow: inset 0px 1px 0px #fff,0px 4px 0px #105378,1px 6px 6px 3px rgba(0,0,0,0.3);}.button-1.button-3d:active{-webkit-box-shadow: inset 0px 1px 0px #fff,0px 0px 0px #105378,1px 4px 6px 3px rgba(0,0,0,0.3);
  	-moz-box-shadow: inset 0px 1px 0px #fff,0px 0px 0px #105378,1px 4px 6px 3px rgba(0,0,0,0.3);
  	box-shadow: inset 0px 1px 0px #fff,0px 0px 0px #105378,1px 4px 6px 3px rgba(0,0,0,0.3);}.fusion-button.button-1:hover .fusion-button-text, .fusion-button.button-1:hover i,.fusion-button.button-1:focus .fusion-button-text, .fusion-button.button-1:focus i,.fusion-button.button-1:active .fusion-button-text, .fusion-button.button-1:active{color:#ffffff;}.fusion-button.button-1:hover, .fusion-button.button-1:focus, .fusion-button.button-1:active{border-width:0px;border-color:#ffffff;}.fusion-button.button-1:hover .fusion-button-icon-divider, .fusion-button.button-1:hover .fusion-button-icon-divider, .fusion-button.button-1:active .fusion-button-icon-divider{border-color:#ffffff;}.fusion-button.button-1{background: #1b9cd7;}.fusion-button.button-1:hover,.button-1:focus,.fusion-button.button-1:active{background: #5aabd6;
							background-image: -webkit-gradient( linear, left bottom, left top, from( #6bb4d6 ), to( #5aabd6 ) );
							background-image: -webkit-linear-gradient( bottom, #6bb4d6, #5aabd6 );
							background-image:   -moz-linear-gradient( bottom, #6bb4d6, #5aabd6 );
							background-image:     -o-linear-gradient( bottom, #6bb4d6, #5aabd6 );
							background-image: linear-gradient( to top, #6bb4d6, #5aabd6 );}.fusion-button.button-1{width:auto;}</style>

							<input id="signup-submit" class="fusion-button button-3d fusion-button-round button-large button-custom button-1" type="submit" name="signup-submit" value="Continuar" />
							<input type="hidden" name="url" value="'.$url.'">
							<input type="hidden" id="qformulario" name="qformulario" value="registro-step2">
						</div>

					<div class="fusion-clearfix"></div>

					</div>
				</div>
				
		</div>
	</div>
</form>
<div id="resjs"></div>

<!-- #signup -->
';
echo $signup_form_left;
				 ?>
			</div>
			<?php if ( ! post_password_required( $post->ID ) ) : ?>
				<?php if ( class_exists( 'WooCommerce' ) ) : ?>
					<?php $woo_thanks_page_id = get_option( 'woocommerce_thanks_page_id' ); ?>
					<?php $is_woo_thanks_page = ( ! get_option( 'woocommerce_thanks_page_id' ) ) ? false : is_page( get_option( 'woocommerce_thanks_page_id' ) ); ?>
					<?php if ( Avada()->settings->get( 'comments_pages' ) && ! is_cart() && ! is_checkout() && ! is_account_page() && ! $is_woo_thanks_page ) : ?>
						<?php wp_reset_postdata(); ?>
						<?php comments_template(); ?>
					<?php endif; ?>
				<?php else : ?>
					<?php if ( Avada()->settings->get( 'comments_pages' ) ) : ?>
						<?php wp_reset_postdata(); ?>
						<?php comments_template(); ?>
					<?php endif; ?>
				<?php endif; ?>
			<?php endif; // Password check. ?>
		</div>
	<?php endwhile; ?>
	<?php wp_reset_postdata(); ?>
</div>

<?php do_action( 'avada_after_content' ); ?>
<?php get_footer();

/* Omit closing PHP tag to avoid "Headers already sent" issues. */
